#!/bin/sh 
 # Copyright (c) 2017-2019 by Pulse Secure, LLC. All rights reserved
 
set -e
cleanup() {
    if [ -d "../pulsePsal" ]
    then
       rm -rf ../pulsePsal
     fi
}

mkdir -p pulsePsal
cd pulsePsal
rpm2cpio ../PulseSecureAppLauncher.rpm | cpio -idmv

cd ./psallinux/bin/
./verifyUtil ../cert/domain.crt psallinux
cd ../../

mkdir -p ~/.mozilla/native-messaging-hosts
mv ./psallinux/doc/psallinux.json ~/.mozilla/native-messaging-hosts/
sed -i "s@USR_PATH@$HOME@" ~/.mozilla/native-messaging-hosts/psallinux.json
mkdir -p ~/psallinux/bin
mkdir -p ~/psallinux/cert
mv ./psallinux/bin/version.ini ~/psallinux/bin/
mv ./psallinux/bin/psallinux ~/psallinux/bin/

mv ./psallinux/cert/domain.crt ~/psallinux/cert/domain.crt
rm -rf ../pulsePsal
